<?php
// Test database connection script
// This file should be deleted after testing

// Load configuration
require_once __DIR__ . '/config.php';

echo "Testing Database Connection...\n\n";

// Show current configuration (without password)
echo "Configuration:\n";
echo "- DB_HOST: " . getConfig('DB_HOST', 'localhost') . "\n";
echo "- DB_NAME: " . getConfig('DB_NAME', 'markxwyo_Asteroids') . "\n";
echo "- DB_USER: " . getConfig('DB_USER', 'markxwyo_admin') . "\n";
echo "- DB_PASS: " . (getConfig('DB_PASS') ? '[SET]' : '[NOT SET]') . "\n";
echo "- ENVIRONMENT: " . getConfig('ENVIRONMENT', 'development') . "\n\n";

// Check if config.env exists
if (!file_exists(__DIR__ . '/config.env')) {
    echo "WARNING: config.env file not found!\n";
    echo "Using default/hardcoded values from db.php\n\n";
}

// Try to connect
$host = getConfig('DB_HOST', 'localhost');
$dbname = getConfig('DB_NAME', 'markxwyo_Asteroids');
$username = getConfig('DB_USER', 'markxwyo_admin');
$password = getConfig('DB_PASS', 'Homiez@420');

echo "Attempting connection...\n";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "SUCCESS: Database connection established!\n";
    
    // Test query
    $stmt = $pdo->query("SELECT VERSION() as version");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "MySQL Version: " . $result['version'] . "\n";
    
} catch(PDOException $e) {
    echo "ERROR: Connection failed!\n";
    echo "Error message: " . $e->getMessage() . "\n\n";
    
    // Common issues and solutions
    echo "Common causes:\n";
    echo "1. MySQL server is not running\n";
    echo "2. Database '" . $dbname . "' does not exist\n";
    echo "3. User '" . $username . "' does not exist or wrong password\n";
    echo "4. User lacks permissions for the database\n";
    echo "5. Wrong host (should it be '127.0.0.1' instead of 'localhost'?)\n";
}
?>
