<?php
require_once 'security_headers.php';
require 'db.php';
require_once 'csrf.php';
require_once 'rate_limiter.php';
session_start();

// Initialize rate limiter
$rateLimiter = new RateLimiter($pdo);
$clientIP = $rateLimiter->getClientIP();

if ($_POST) {
    // Check rate limit for registration
    if (!$rateLimiter->checkLimit($clientIP, 'register')) {
        $error = "Too many registration attempts. Please try again later.";
    } else {
        // Validate CSRF token
        validateCSRF();
    
    // Get and validate input
    $login_name = trim($_POST['login_name'] ?? '');
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $display_name = !empty($_POST['display_name']) ? trim($_POST['display_name']) : $login_name;
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    
    // Basic validation
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = "Please enter a valid email address";
    } elseif (strlen($login_name) < 3) {
        $error = "Login name must be at least 3 characters long";
    } elseif (strlen($_POST['password']) < 6) {
        $error = "Password must be at least 6 characters long";
    } else {
        try {
            $stmt = $pdo->prepare("INSERT INTO users (username, email, display_name, password) VALUES (?, ?, ?, ?)");
            $stmt->execute([$login_name, $email, $display_name, $password]);
            // Don't auto-login after registration, redirect to login page
            $_SESSION['registration_success'] = true;
            header("Location: login.php");
            exit();
        } catch(PDOException $e) {
            // Log the actual error for debugging
            error_log("Registration error: " . $e->getMessage());
            // Generic error to prevent username enumeration
            $error = "Registration failed. Please try again with different credentials.";
        }
    }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Register - Asteroids</title>
    <link rel="stylesheet" type="text/css" href="style.css">
</head>                                                                                                                                                                          6
<body>
    <div class="auth-container">
        <h2>Register</h2>
        <?php if (isset($error)) echo "<p class='error'>" . htmlspecialchars($error) . "</p>"; ?>
        <form method="post">
            <?php echo getCSRFField(); ?>
            <input type="text" name="login_name" placeholder="Login  name (min 3 characters)" required minlength="3">
            <input type="email" name="email" placeholder="Email address" required>
            <input type="password" name="password" placeholder="Password (min 6 characters)" required minlength="6">
            <input type="text" name="display_name" placeholder="Display name (optional)">
            <button type="submit">Register</button>
        </form>
        <a href="login.php">Already have an account? Login</a>
    </div>
</body>
</html>