<?php
require_once 'security_headers.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Asteroids Game</title>
    <link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
    <div class="game-container">
        <div class="game-header">
            <div class="player-info">
                Welcome, <?php echo isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Player'; ?> | 
                <a href="logout.php">Logout</a>
            </div>
            <div class="game-stats">
                <div>Lives: <span id="lives">5</span></div>
                <div>Round: <span id="round">1</span></div>
                <div>Score: <span id="score">0</span></div>
            </div>
        </div>
        
        <canvas id="gameCanvas" width="800" height="600"></canvas>
        
        <div id="playNowButton" class="play-now-button">
            <button id="startGameBtn" class="blinking-button">PLAY NOW</button>
        </div>
        
        <div id="pauseIndicator" class="pause-indicator"></div>
        
        <div id="gameOver" class="hidden">
            <h2>Game Over!</h2>
            <p>Final Score: <span id="finalScore">0</span></p>
            <p>Lives Lost: All 5 lives</p>
            <div class="game-over-choices">
                <p>What would you like to do?</p>
                <button id="playAgain">Play Again</button>
                <button id="endGameBtn">End Game</button>
            </div>
        </div>
    </div>
    
    <script src="game.js"></script>
</body>
</html>