<?php
require_once 'security_headers.php';
require_once 'adsense_config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Example Page with AdSense</title>
    
    <!-- Include AdSense Script -->
    <?php includeAdsenseScript(); ?>
    
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        .content {
            margin: 20px 0;
        }
        .ad-container {
            margin: 30px 0;
            padding: 20px;
            background: #f5f5f5;
            border: 1px solid #ddd;
            text-align: center;
        }
        .ad-label {
            font-size: 12px;
            color: #666;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <h1>Example Page with Google AdSense Integration</h1>
    
    <div class="content">
        <p>This is an example page showing how to properly integrate Google AdSense with the correct Content Security Policy headers.</p>
    </div>
    
    <!-- Ad Unit 1: Responsive Display Ad -->
    <div class="ad-container">
        <div class="ad-label">Advertisement</div>
        <?php 
        // Replace 'YOUR_AD_SLOT_ID' with your actual ad slot ID from AdSense
        // displayAdsenseAd('YOUR_AD_SLOT_ID', 'auto', true); 
        ?>
        <!-- For now, showing placeholder -->
        <p style="padding: 40px; background: #e0e0e0;">AdSense Ad Placeholder - Replace with actual ad slot ID</p>
    </div>
    
    <div class="content">
        <h2>Important Notes:</h2>
        <ul>
            <li>Replace 'ca-pub-9807741295373154' in adsense_config.php with your actual AdSense publisher ID</li>
            <li>Replace 'YOUR_AD_SLOT_ID' with your actual ad slot IDs from your AdSense account</li>
            <li>The Content Security Policy has been configured to allow AdSense scripts</li>
            <li>Make sure your site is approved by AdSense before ads will display</li>
            <li>Test thoroughly to ensure ads display correctly</li>
        </ul>
    </div>
    
    <!-- Ad Unit 2: Another ad placement -->
    <div class="ad-container">
        <div class="ad-label">Advertisement</div>
        <?php 
        // displayAdsenseAd('ANOTHER_AD_SLOT_ID', 'rectangle', true); 
        ?>
        <p style="padding: 40px; background: #e0e0e0;">AdSense Ad Placeholder - Replace with actual ad slot ID</p>
    </div>
    
    <div class="content">
        <h2>CSP Configuration</h2>
        <p>The Content Security Policy has been updated to allow:</p>
        <ul>
            <li>Google AdSense scripts from pagead2.googlesyndication.com</li>
            <li>DoubleClick scripts from googleads.g.doubleclick.net</li>
            <li>Google Tag Services from www.googletagservices.com</li>
            <li>Google reCAPTCHA from www.google.com/recaptcha/</li>
            <li>Bootstrap CSS from cdn.jsdelivr.net</li>
            <li>Font Awesome from cdnjs.cloudflare.com</li>
        </ul>
    </div>
</body>
</html>
