export class Asteroid {
    constructor(x, y, size, coinImage, scaleFactor = 1) {
        this.x = x;
        this.y = y;
        this.size = size;
        this.image = coinImage;
        
        switch(size) {
            case 'large':
                this.radius = 90 * scaleFactor; // 3X bigger (was 30)
                this.speed = 0.8 * scaleFactor; // Slightly slower for balance
                break;
            case 'medium':
                this.radius = 60 * scaleFactor; // 3X bigger (was 20)
                this.speed = 1.2 * scaleFactor; // Slightly slower for balance
                break;
            case 'small':
                this.radius = 30 * scaleFactor; // 3X bigger (was 10)
                this.speed = 1.5 * scaleFactor; // Keep reasonable speed
                break;
        }
        
        const angle = Math.random() * Math.PI * 2;
        this.vx = Math.cos(angle) * this.speed;
        this.vy = Math.sin(angle) * this.speed;
        
        if (size === 'small') {
            this.creationTime = Date.now();
        }
    }
    
    update(canvasWidth, canvasHeight) {
        this.x += this.vx;
        this.y += this.vy;
        
        if (this.x < -this.radius) this.x = canvasWidth + this.radius;
        if (this.x > canvasWidth + this.radius) this.x = -this.radius;
        if (this.y < -this.radius) this.y = canvasHeight + this.radius;
        if (this.y > canvasHeight + this.radius) this.y = -this.radius;
    }
    
    draw(ctx) {
        ctx.save();
        ctx.translate(this.x, this.y);
        
        ctx.beginPath();
        ctx.arc(0, 0, this.radius, 0, Math.PI * 2);
        ctx.closePath();
        ctx.clip();
        
        const imageSize = this.radius * 2;
        ctx.drawImage(this.image, -imageSize/2, -imageSize/2, imageSize, imageSize);
        
        ctx.restore();
    }
}
