import React from 'react';
import './GameUI.css';

const GameUI = ({ gameState }) => {
    if (gameState.lives <= 0 && !gameState.gameActive) {
        return (
            <div className="game-over">
                <h2>MISSION FAILED</h2>
                <p>Crystals Collected: <span>{gameState.score}</span></p>
                <p>Hull Integrity: Critical Failure</p>
                <div className="game-over-choices">
                    <p>Humanity's fate hangs in the balance...</p>
                    <button onClick={() => window.location.reload()}>Retry Mission</button>
                    <button onClick={() => window.location.href = 'logout.php'}>Abandon Mission</button>
                </div>
            </div>
        );
    }

    return null;
};

export default GameUI;
