import React from 'react';
import { useGame } from '../hooks/useGame';
import GameCanvas from './GameCanvas';
import GameUI from './GameUI';
import GameStats from './GameStats';
import PlayerInfo from './PlayerInfo';
import './GameContainer.css';

const GameContainer = () => {
    const {
        canvasRef,
        gameState,
        gameObjects,
        startGame,
        togglePause
    } = useGame();

    return (
        <div className="game-container">
            <div className="game-layout">
                <PlayerInfo />
                <div className="game-center">
                    <GameCanvas
                        canvasRef={canvasRef}
                        gameState={gameState}
                        startGame={startGame}
                        togglePause={togglePause}
                    />
                    <GameUI gameState={gameState} />
                </div>
                <GameStats gameState={gameState} />
            </div>
        </div>
    );
};

export default GameContainer;
