import React from 'react';
import './GameCanvas.css';

const GameCanvas = ({ canvasRef, gameState, startGame, togglePause }) => {
    return (
        <>
            <canvas
                ref={canvasRef}
                id="gameCanvas"
                className="game-canvas"
            />
            
            {!gameState.gameStarted && (
                <div className="play-now-button">
                    <button 
                        className="blinking-button"
                        onClick={startGame}
                    >
                        BEGIN MISSION
                    </button>
                </div>
            )}
            
            {gameState.gamePaused && (
                <div className="pause-indicator">
                    MISSION PAUSED
                </div>
            )}
        </>
    );
};

export default GameCanvas;
