# Cosmic Defender - Namecheap Stellar Hosting Deployment

## Overview
This guide will help you deploy the Cosmic Defender React game to Namecheap Stellar shared hosting.

## Prerequisites
- Node.js and npm installed locally
- Namecheap Stellar hosting account
- Access to cPanel

## Quick Deployment Steps

### 1. Build the Game
```bash
# On Windows
deploy.bat

# On Mac/Linux
chmod +x deploy.sh
./deploy.sh
```

### 2. Upload to Namecheap
1. **Login to Namecheap cPanel**
   - Go to yourdomain.com/cpanel
   - Enter your credentials

2. **Open File Manager**
   - Find "File Manager" in the Files section
   - Click to open

3. **Navigate to public_html**
   - This is your web root directory
   - Clear existing files if needed

4. **Upload Game Files**
   - Click "Upload" button
   - Select all files from the `deploy` directory
   - Make sure to include `.htaccess` file
   - Upload and overwrite if prompted

### 3. Verify Deployment
- Visit your domain: `https://yourdomain.com`
- The game should load with the "BEGIN MISSION" button

## Game Controls
- **Arrow Keys**: Move ship
- **Space**: Fire bullets
- **P**: Pause/Resume game

## Technical Details

### Server Configuration (.htaccess)
The `.htaccess` file handles:
- URL rewriting for React Router
- Proper MIME types
- Gzip compression
- Browser caching
- Security headers

### Build Optimization
- Static files are minified
- Assets are optimized
- Code is bundled for production
- No external dependencies

## Troubleshooting

### Game Doesn't Load
1. Check if all files uploaded correctly
2. Verify `.htaccess` is in the root
3. Clear browser cache
4. Check browser console for errors

### Images Not Showing
- The game uses programmatically generated images
- No external image files needed
- Should work automatically

### Controls Not Working
- Make sure JavaScript is enabled
- Click on the game canvas first
- Check browser console for errors

## File Structure After Upload
```
public_html/
├── index.html
├── static/
│   ├── css/
│   ├── js/
│   └── media/
├── .htaccess
└── (other build files)
```

## Performance Tips
- The game is optimized for smooth performance
- Uses requestAnimationFrame for 60fps
- Efficient collision detection
- Minimal memory usage

## Support
If you encounter issues:
1. Check browser console (F12)
2. Verify all files uploaded
3. Ensure Namecheap hosting supports PHP/HTML
4. Contact Namecheap support if server issues

## Game Features
- 🚀 Smooth spaceship controls
- 💥 Explosion effects
- 🎯 Progressive difficulty
- 📊 Score tracking
- 📱 Responsive design
- ⚡ Optimized performance
