<?php
require_once 'security_headers.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Asteroids Game</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <style>
        /* Avatar Modal Styles */
        .modal {
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.7);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .modal-content {
            background: linear-gradient(135deg, #1a1a2e 0%, #0f0f23 100%);
            padding: 20px;
            border-radius: 10px;
            border: 2px solid #4CAF50;
            max-width: 400px;
            width: 90%;
            color: white;
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            border-bottom: 1px solid #333;
            padding-bottom: 10px;
        }
        
        .modal-header h3 {
            margin: 0;
            color: #4CAF50;
        }
        
        .close {
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            color: #666;
        }
        
        .close:hover {
            color: #fff;
        }
        
        .current-avatar {
            text-align: center;
            margin-bottom: 20px;
        }
        
        .upload-area {
            border: 2px dashed #4CAF50;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            background: rgba(76, 175, 80, 0.1);
        }
        
        .upload-area:hover {
            background: rgba(76, 175, 80, 0.2);
            border-color: #45a049;
        }
        
        .upload-text p {
            margin: 5px 0;
        }
        
        .btn {
            background: #4CAF50;
            color: white;
            padding: 12px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s ease;
        }
        
        .btn:hover {
            background: #45a049;
        }
    </style>
</head>
<body>
    <div class="game-container">
        <div class="game-header">
            <div class="player-info">
                <div class="player-avatar" onclick="showAvatarModal()" style="cursor: pointer; position: relative;">
                    <?php if (!empty($_SESSION['avatar_url'])): ?>
                        <img src="<?php echo htmlspecialchars($_SESSION['avatar_url']); ?>" alt="Avatar" width="30" height="30" style="border-radius: 50%; vertical-align: middle;">
                        <div style="position: absolute; bottom: -2px; right: -2px; background: #4CAF50; border-radius: 50%; width: 12px; height: 12px; font-size: 8px; display: flex; align-items: center; justify-content: center;">📷</div>
                    <?php else: ?>
                        <span style="font-size: 24px;">👤</span>
                        <div style="position: absolute; bottom: -2px; right: -2px; background: #4CAF50; border-radius: 50%; width: 12px; height: 12px; font-size: 8px; display: flex; align-items: center; justify-content: center;">+</div>
                    <?php endif; ?>
                </div>
                Welcome, <a href="profile.php" style="color: #4CAF50; text-decoration: none;">
                    <?php echo isset($_SESSION['display_name']) ? htmlspecialchars($_SESSION['display_name']) : htmlspecialchars($_SESSION['username'] ?? 'Player'); ?>
                </a> | 
                <a href="logout.php">Logout</a>
            </div>
            <div class="game-stats">
                <div>Lives: <span id="lives">5</span></div>
                <div>Round: <span id="round">1</span></div>
                <div>Score: <span id="score">0</span></div>
            </div>
        </div>
        
        <canvas id="gameCanvas" width="800" height="600"></canvas>
        
        <div id="playNowButton" class="play-now-button">
            <button id="startGameBtn" class="blinking-button">PLAY NOW</button>
        </div>
        
        <div id="pauseIndicator" class="pause-indicator"></div>
        
        <div id="gameOver" class="hidden">
            <h2>Game Over!</h2>
            <p>Final Score: <span id="finalScore">0</span></p>
            <p>Lives Lost: All 5 lives</p>
            <div class="game-over-choices">
                <p>What would you like to do?</p>
                <button id="playAgain">Play Again</button>
                <button id="endGameBtn">End Game</button>
            </div>
        </div>
    </div>
    
    <!-- Avatar Upload Modal -->
    <div id="avatarModal" class="modal" style="display: none;">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Update Avatar</h3>
                <span class="close" onclick="closeAvatarModal()">&times;</span>
            </div>
            <div class="modal-body">
                <div class="current-avatar">
                    <p>Current Avatar:</p>
                    <?php if (!empty($_SESSION['avatar_url'])): ?>
                        <img src="<?php echo htmlspecialchars($_SESSION['avatar_url']); ?>" alt="Current Avatar" style="width: 80px; height: 80px; border-radius: 50%; object-fit: cover;">
                    <?php else: ?>
                        <div style="width: 80px; height: 80px; border-radius: 50%; background: #333; display: flex; align-items: center; justify-content: center; font-size: 40px;">👤</div>
                    <?php endif; ?>
                </div>
                
                <form id="avatarForm" enctype="multipart/form-data">
                    <?php echo getCSRFField(); ?>
                    <div class="upload-area" id="uploadArea">
                        <input type="file" id="avatarFile" name="avatar" accept="image/*" style="display: none;">
                        <div class="upload-text">
                            <p>📷 Click to upload new avatar</p>
                            <p style="font-size: 12px; color: #666;">JPEG, PNG, GIF, WebP (Max 2MB)</p>
                        </div>
                    </div>
                    <div id="uploadPreview" style="display: none; text-align: center; margin: 10px 0;">
                        <img id="previewImage" style="width: 100px; height: 100px; border-radius: 50%; object-fit: cover;">
                    </div>
                    <button type="submit" class="btn" style="width: 100%; margin-top: 10px;">Upload Avatar</button>
                </form>
            </div>
        </div>
    </div>
    
    <script>
        // Avatar upload functionality
        function showAvatarModal() {
            document.getElementById('avatarModal').style.display = 'block';
        }
        
        function closeAvatarModal() {
            document.getElementById('avatarModal').style.display = 'none';
            document.getElementById('avatarForm').reset();
            document.getElementById('uploadPreview').style.display = 'none';
        }
        
        // Upload area click
        document.getElementById('uploadArea').addEventListener('click', function() {
            document.getElementById('avatarFile').click();
        });
        
        // File preview
        document.getElementById('avatarFile').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('previewImage').src = e.target.result;
                    document.getElementById('uploadPreview').style.display = 'block';
                };
                reader.readAsDataURL(file);
            }
        });
        
        // Form submission
        document.getElementById('avatarForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData();
            formData.append('avatar', document.getElementById('avatarFile').files[0]);
            formData.append('csrf_token', document.querySelector('input[name="csrf_token"]').value);
            
            fetch('upload_avatar.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Update avatar in header
                    const avatarDiv = document.querySelector('.player-avatar');
                    avatarDiv.innerHTML = `
                        <img src="${data.avatar_url}" alt="Avatar" width="30" height="30" style="border-radius: 50%; vertical-align: middle;">
                        <div style="position: absolute; bottom: -2px; right: -2px; background: #4CAF50; border-radius: 50%; width: 12px; height: 12px; font-size: 8px; display: flex; align-items: center; justify-content: center;">📷</div>
                    `;
                    closeAvatarModal();
                    alert('Avatar updated successfully!');
                } else {
                    alert('Error: ' + data.error);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Upload failed. Please try again.');
            });
        });
        
        // Close modal when clicking outside
        window.addEventListener('click', function(e) {
            const modal = document.getElementById('avatarModal');
            if (e.target === modal) {
                closeAvatarModal();
            }
        });
    </script>
    
    <script src="game.js"></script>
</body>
</html>