<?php
/**
 * Admin Setup Script
 * Run this once to create admin credentials and database tables
 */

require_once 'AdminAuth.php';

echo "=== Mark's Tech Solution Admin Setup ===\n\n";

try {
    // Initialize admin system
    echo "1. Checking admin system...\n";
    $initialized = $adminAuth->initializeAdminSystem();
    
    if ($initialized) {
        echo "✅ Admin system initialized successfully!\n";
        echo "📋 Default admin credentials created:\n";
        echo "   Username: admin\n";
        echo "   Password: admin123\n";
        echo "   Email: admin@markstechsolution.com\n\n";
        echo "⚠️  IMPORTANT: Change the default password immediately after first login!\n\n";
    } else {
        echo "ℹ️  Admin system already exists\n";
    }
    
    // Check existing admin users
    echo "2. Checking existing admin users...\n";
    $admins = $adminAuth->getAllAdmins();
    
    if (empty($admins)) {
        echo "❌ No admin users found\n";
    } else {
        echo "✅ Found " . count($admins) . " admin user(s):\n";
        foreach ($admins as $admin) {
            $status = $admin['is_active'] ? 'Active' : 'Inactive';
            $lastLogin = $admin['last_login'] ? date('M j, Y H:i', strtotime($admin['last_login'])) : 'Never';
            echo "   - {$admin['username']} ({$admin['role']}) - {$status} - Last login: {$lastLogin}\n";
        }
    }
    
    echo "\n=== Setup Complete ===\n";
    echo "🔗 Admin Dashboard: admin_dashboard.php\n";
    echo "🔐 Change default password immediately for security!\n";
    
} catch (Exception $e) {
    echo "❌ Setup failed: " . $e->getMessage() . "\n";
    echo "Check your database connection and permissions.\n";
}
?>
