<?php
require_once 'csp_config.php';
require_once 'config_loader.php';
require_once 'CsrfProtection.php';

$currentDir = trim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '/')), '/');
$depth = ($currentDir === '') ? 0 : (substr_count($currentDir, '/') + 1);
$urlPrefix = ($depth === 0) ? '' : str_repeat('../', $depth);

// Generate and send CSP header
send_security_headers();

// Start session for CSRF protection
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$pageTitle = "Full Service Agreement - Mark's Tech Solution";
$extraHead = <<<HTML
<link rel="stylesheet" href="legal_documents.css">
HTML;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <script src="https://www.google.com/recaptcha/enterprise.js?render=6LeUoSksAAAAAG7oSdSl4zKoBxmo7e1Pq5nih2iU"></script>
    <meta name="google-adsense-account" content="ca-pub-9807741295373154">
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-9807741295373154"
     crossorigin="anonymous"></script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Comprehensive service agreement for Mark's Tech Solution LLC covering network services, printer repair, consultation, and computer repair services.">
    <meta name="keywords" content="service agreement, computer repair, network services, printer repair, IT consultation, Mark's Tech Solution">
    <meta name="author" content="Mark's Tech Solution">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://markstechsolution.com/">
    <meta property="og:title" content="Mark's Tech Solution - Full Service Agreement">
    <meta property="og:description" content="Comprehensive service agreement covering all IT services offered by Mark's Tech Solution LLC.">
    <meta property="og:image" content="https://markstechsolution.com/images/og-image.jpg">
    <meta property="og:site_name" content="Mark's Tech Solution">
    <meta property="og:locale" content="en_US">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://markstechsolution.com/">
    <meta property="twitter:title" content="Mark's Tech Solution - Full Service Agreement">
    <meta property="twitter:description" content="Comprehensive service agreement covering all IT services offered by Mark's Tech Solution LLC.">
    <meta property="twitter:image" content="https://markstechsolution.com/images/twitter-image.jpg">
    
    <!-- Additional SEO -->
    <link rel="canonical" href="https://markstechsolution.com/">
    <meta name="geo.region" content="US-MA">
    <meta name="geo.placename" content="East Weymouth">
    <meta name="geo.position" content="42.226008;-70.945108">
    <meta name="ICBM" content="42.226008, -70.945108">
    <title><?php echo htmlspecialchars($pageTitle ?? "Mark's Tech Solution - Your Local Tech Experts", ENT_QUOTES, 'UTF-8'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha512-9usAa10IRO0HhonpyAIVpjrylPvoDwiPUiKdWk5t3PyolY1cOd4DSE0Ga+ri4AuTroPR5aQvXU9xC6qOPnzFeg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo $urlPrefix; ?>styles.css">

<?php if (!empty($extraHead)) { echo $extraHead; } ?>
</head>
<body>
    <!-- Skip Navigation -->
    <a href="#main-content" class="skip-nav visually-hidden-focusable">Skip to main content</a>
    
    <!-- Custom Header for Legal Documents -->
    <header class="legal-header">
        <div class="container">
            <div class="legal-header-content">
                <a href="<?php echo $urlPrefix; ?>Main_Site/legal-documents.php" class="legal-back-link">
                    <i class="fas fa-arrow-left"></i>
                    Back to Legal Documents
                </a>
                <div class="legal-logo">
                    <div class="logo-placeholder">MTS</div>
                    <span>Mark's Tech Solution</span>
                </div>
                <div class="legal-contact">
                    <a href="tel:6173026011" class="legal-phone">
                        <i class="fas fa-phone"></i>
                        (617) 302-6011
                    </a>
                </div>
            </div>
        </div>
    </header>
    
<main id="main-content" class="legal-documents-page">
    <div class="container">
        <div class="header">
            <h1>Mark's Tech Solution LLC</h1>
            <div class="subtitle">Full Service Agreement</div>
        </div>

        <div class="effective-date">Effective Date: <span id="currentDate"></span></div>

        <div class="document-section">
            <h2>Full Service Agreement</h2>
            <p>This Full Service Agreement ("Agreement") is entered into between Mark's Tech Solution LLC ("Company") and the client ("Client") for the provision of comprehensive IT services. By engaging our services, the Client agrees to be bound by the terms and conditions outlined herein.</p>

            <h3>1. Services Offered</h3>
            <p>Mark's Tech Solution LLC provides the following comprehensive IT services:</p>
            
            <h4>1.1 Network Services</h4>
            <ul>
                <li><strong>Network Design & Build:</strong> Complete network infrastructure planning, design, and implementation for residential and commercial clients</li>
                <li><strong>Network Maintenance:</strong> Ongoing network support, monitoring, and optimization services</li>
                <li><strong>Network Repair:</strong> Troubleshooting and repair of network connectivity issues, hardware failures, and performance problems</li>
                <li><strong>Wired Network Setup:</strong> Ethernet cabling, switch configuration, router setup, and network device integration</li>
                <li><strong>Wireless Network Setup:</strong> WiFi network design, access point installation, security configuration, and optimization</li>
            </ul>

            <h4>1.2 Printer Services</h4>
            <ul>
                <li><strong>Printer Repair:</strong> Hardware and software troubleshooting for all major printer brands and models</li>
                <li><strong>Printer Setup:</strong> Installation, configuration, and network integration of new printers</li>
                <li><strong>Driver Installation:</strong> Software driver setup and troubleshooting for Windows and macOS systems</li>
                <li><strong>Network Printer Configuration:</strong> Setup of shared network printers and multi-device printing solutions</li>
                <li><strong>Printer Maintenance:</strong> Cleaning, calibration, and preventive maintenance services</li>
            </ul>

            <h4>1.3 IT Consultation Services</h4>
            <ul>
                <li><strong>Technology Assessment:</strong> Comprehensive evaluation of current IT infrastructure and recommendations</li>
                <li><strong>System Planning:</strong> Strategic planning for technology upgrades and system expansions</li>
                <li><strong>Security Consultation:</strong> Network security assessment and implementation of security measures</li>
                <li><strong>Hardware Recommendations:</strong> Expert advice on equipment purchases and system configurations</li>
                <li><strong>Process Optimization:</strong> Workflow analysis and technology integration recommendations</li>
            </ul>

            <h4>1.4 Computer Repair & Maintenance</h4>
            <ul>
                <li><strong>Laptop Repair:</strong> Hardware and software repair for all laptop makes and models (excluding Apple products)</li>
                <li><strong>Desktop Repair:</strong> Complete desktop computer repair and upgrade services (excluding Apple products)</li>
                <li><strong>Software Updates:</strong> Operating system updates, driver updates, and software installation</li>
                <li><strong>Virus & Malware Removal:</strong> Comprehensive security scanning and malware removal services</li>
                <li><strong>Data Recovery:</strong> Data recovery services from failed hard drives and storage devices</li>
                <li><strong>Hardware Upgrades:</strong> RAM upgrades, SSD installation, graphics card upgrades, and component replacements</li>
                <li><strong>System Optimization:</strong> Performance tuning and cleanup services for optimal system performance</li>
            </ul>

            <h3>2. Service Terms and Conditions</h3>
            
            <h4>2.1 Service Scope</h4>
            <ul>
                <li>Services are provided for Windows-based computers and compatible hardware only</li>
                <li>Apple products (Mac, iPhone, iPad, etc.) are not supported under this agreement</li>
                <li>Services include both on-site and remote support options as appropriate</li>
                <li>Emergency services are available with additional charges</li>
            </ul>

            <h4>2.2 Payment Terms</h4>
            <ul>
                <li><strong>Diagnostic Fee:</strong> $75-150 depending on complexity (applied toward service if work is completed)</li>
                <li><strong>Hourly Rates:</strong> $85-125 per hour based on service type and complexity</li>
                <li><strong>On-Site Service:</strong> Minimum 2-hour charge plus travel time if applicable</li>
                <li><strong>Remote Service:</strong> Minimum 1-hour charge, billed in 15-minute increments</li>
                <li><strong>Parts & Materials:</strong> Cost of parts plus 20% markup for procurement and handling</li>
                <li><strong>Payment Due:</strong> Upon completion of services unless alternative arrangements are made</li>
                <li><strong>Late Fees:</strong> 1.5% per month on overdue balances</li>
            </ul>

            <h4>2.3 Warranty and Guarantees</h4>
            <ul>
                <li><strong>Labor Warranty:</strong> 30 days on all repair services performed</li>
                <li><strong>Parts Warranty:</strong> Manufacturer's warranty on all replacement parts (typically 90 days to 1 year)</li>
                <li><strong>Software Services:</strong> No warranty on software installations or configurations</li>
                <li><strong>Network Services:</strong> 30-day warranty on network configurations and setups</li>
                <li>Warranty void if equipment is modified by unauthorized parties</li>
            </ul>

            <h3>3. Client Responsibilities</h3>
            <ul>
                <li>Provide accurate information about equipment and issues</li>
                <li>Back up all important data before service begins</li>
                <li>Provide safe working environment and access to equipment</li>
                <li>Disclose all known issues and relevant system information</li>
                <li>Make payment as agreed upon service completion</li>
                <li>Test services upon completion and report issues within warranty period</li>
                <li>Provide necessary software licenses and product keys</li>
            </ul>

            <h3>4. Limitations of Liability</h3>
            <p class="highlight">Mark's Tech Solution LLC's liability is limited to the cost of services provided. We are not liable for:</p>
            <ul>
                <li>Data loss or corruption (Client is responsible for data backups)</li>
                <li>Consequential, incidental, or punitive damages</li>
                <li>Loss of business, profits, or revenue</li>
                <li>Issues arising from Client actions after service completion</li>
                <li>Software compatibility issues beyond our control</li>
                <li>Hardware failures due to age, wear, or manufacturer defects</li>
            </ul>

            <h3>5. Data Protection and Privacy</h3>
            <ul>
                <li>We implement reasonable security measures to protect Client data</li>
                <li>Client data is retained only as necessary for service completion and warranty support</li>
                <li>We do not share Client information with third parties without consent</li>
                <li>Confidential business information is protected under confidentiality agreements</li>
                <li>Data is securely deleted when no longer needed for service purposes</li>
            </ul>

            <h3>6. Service Limitations</h3>
            <ul>
                <li>We cannot guarantee recovery of all lost data or resolution of all technical issues</li>
                <li>Some problems may be beyond repair due to hardware failure or extensive damage</li>
                <li>Software issues may require manufacturer support or complete system reinstallation</li>
                <li>Network performance may be limited by ISP service quality or infrastructure limitations</li>
                <li>Older equipment may not support modern software or security requirements</li>
            </ul>

            <h3>7. Cancellation and Refund Policy</h3>
            <ul>
                <li>24-hour notice required for appointment cancellations to avoid fees</li>
                <li>Late cancellations (less than 24 hours) may incur minimum service charge</li>
                <li>No-show appointments will be charged the minimum service fee</li>
                <li>Refunds provided only for services not rendered or unsatisfactory work</li>
                <li>Refund requests must be made within 7 days of service completion</li>
            </ul>

            <h3>8. Emergency and After-Hours Services</h3>
            <ul>
                <li>Emergency services available 24/7 with additional charges</li>
                <li>Emergency rate: 1.5x standard hourly rate</li>
                <li>After-hours service (6 PM - 8 AM): 1.25x standard rate</li>
                <li>Weekend service: 1.25x standard rate</li>
                <li>Emergency response time: 2-4 hours depending on location</li>
            </ul>

            <h3>9. Intellectual Property</h3>
            <ul>
                <li>Client retains ownership of all data and software licenses</li>
                <li>Mark's Tech Solution retains ownership of proprietary tools and methodologies</li>
                <li>Custom configurations and setups remain Client property</li>
                <li>We reserve the right to use generalized knowledge gained from service work</li>
            </ul>

            <h3>10. Force Majeure</h3>
            <p>We are not liable for delays or failures to perform due to circumstances beyond our control, including but not limited to natural disasters, power outages, internet service interruptions, or other force majeure events.</p>

            <h3>11. Dispute Resolution</h3>
            <ul>
                <li>Disputes will be resolved through good faith negotiation first</li>
                <li>If unresolved, disputes will be mediated through a neutral third party</li>
                <li>Legal proceedings will be conducted in Massachusetts courts</li>
                <li>Prevailing party entitled to reasonable attorney fees and costs</li>
            </ul>

            <h3>12. Agreement Modifications</h3>
            <p>Mark's Tech Solution LLC reserves the right to modify this agreement at any time. Continued use of our services constitutes acceptance of updated terms. Clients will be notified of significant changes via email or posted notice.</p>

            <h3>13. Governing Law</h3>
            <p>This agreement is governed by the laws of the Commonwealth of Massachusetts. Any legal proceedings will be conducted in the appropriate courts of Norfolk County, Massachusetts.</p>

            <h3>14. Entire Agreement</h3>
            <p>This document constitutes the entire agreement between Mark's Tech Solution LLC and the Client. All previous agreements, whether written or oral, are superseded by this agreement.</p>

            <div class="contact-info">
                <h3>Contact Information</h3>
                <p>For questions about this service agreement or to schedule services, contact:</p>
                <p><strong>Mark's Tech Solution LLC</strong><br>
                Email: m.geden01@markstechsolution.com<br>
                Phone: (617) 302-6011<br>
                Address: 16 Dale Rd, East Weymouth, MA 02189<br>
                Website: www.markstechsolution.com</p>
            </div>
        </div>
    </div>
</main>

<script>
    document.getElementById('currentDate').textContent = new Date().toLocaleDateString('en-US', {
        year: 'numeric',
        month: 'long',
        day: 'numeric'
    });
</script>

<?php include __DIR__ . '/components/footer.php'; ?>