<?php
require_once 'csp_config.php';
require_once 'config_loader.php';
require_once 'CsrfProtection.php';

$currentDir = trim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '/')), '/');
$depth = ($currentDir === '') ? 0 : (substr_count($currentDir, '/') + 1);
$urlPrefix = ($depth === 0) ? '' : str_repeat('../', $depth);

// Generate and send CSP header
send_security_headers();

// Start session for CSRF protection
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$pageTitle = "Privacy Policy & Terms - Mark's Tech Solution";
$extraHead = <<<HTML
<link rel="stylesheet" href="legal_documents.css">
HTML;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <script src="https://www.google.com/recaptcha/enterprise.js?render=6LeUoSksAAAAAG7oSdSl4zKoBxmo7e1Pq5nih2iU"></script>
    <meta name="google-adsense-account" content="ca-pub-9807741295373154">
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-9807741295373154"
     crossorigin="anonymous"></script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Professional computer repair, network setup, and IT support services in East Weymouth, MA. On-site tech support, custom PC builds, and reliable tech solutions.">
    <meta name="keywords" content="computer repair, IT support, network setup, tech support, East Weymouth, MA, custom PC builds, wifi installation, computer services">
    <meta name="author" content="Mark's Tech Solution">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://markstechsolution.com/">
    <meta property="og:title" content="Mark's Tech Solution - Professional IT Services in East Weymouth, MA">
    <meta property="og:description" content="Expert computer repair, network setup, and IT support services. Serving East Weymouth and surrounding areas with reliable tech solutions.">
    <meta property="og:image" content="https://markstechsolution.com/images/og-image.jpg">
    <meta property="og:site_name" content="Mark's Tech Solution">
    <meta property="og:locale" content="en_US">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://markstechsolution.com/">
    <meta property="twitter:title" content="Mark's Tech Solution - Professional IT Services">
    <meta property="twitter:description" content="Expert computer repair, network setup, and IT support services in East Weymouth, MA.">
    <meta property="twitter:image" content="https://markstechsolution.com/images/twitter-image.jpg">
    
    <!-- Additional SEO -->
    <link rel="canonical" href="https://markstechsolution.com/">
    <meta name="geo.region" content="US-MA">
    <meta name="geo.placename" content="East Weymouth">
    <meta name="geo.position" content="42.226008;-70.945108">
    <meta name="ICBM" content="42.226008, -70.945108">
    <title><?php echo htmlspecialchars($pageTitle ?? "Mark's Tech Solution - Your Local Tech Experts", ENT_QUOTES, 'UTF-8'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha512-9usAa10IRO0HhonpyAIVpjrylPvoDwiPUiKdWk5t3PyolY1cOd4DSE0Ga+ri4AuTroPR5aQvXU9xC6qOPnzFeg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo $urlPrefix; ?>Main_Site/styles.css">

<?php if (!empty($extraHead)) { echo $extraHead; } ?>
</head>
<body>
    <!-- Skip Navigation -->
    <a href="#main-content" class="skip-nav visually-hidden-focusable">Skip to main content</a>
    
    <!-- Custom Header for Legal Documents -->
    <header class="legal-header">
        <div class="container">
            <div class="legal-header-content">
                <a href="<?php echo $urlPrefix; ?>Main_Site/index.php" class="legal-back-link">
                    <i class="fas fa-arrow-left"></i>
                    Back to Home
                </a>
                <div class="legal-logo">
                    <div class="logo-placeholder">MTS</div>
                    <span>Mark's Tech Solution</span>
                </div>
                <div class="legal-contact">
                    <a href="tel:6173026011" class="legal-phone">
                        <i class="fas fa-phone"></i>
                        (617) 302-6011
                    </a>
                </div>
            </div>
        </div>
    </header>
    
<main id="main-content" class="legal-documents-page">
    <div class="container">
        <div class="header">
            <h1>Mark's Tech Solution</h1>
            <div class="subtitle">Professional IT Services & Computer Repair</div>
        </div>

        <div class="effective-date">Effective Date: <span id="currentDate"></span></div>

        <!-- Legal Documents Navigation -->
        <div class="document-section">
            <h2>Legal Documents</h2>
            <p>Access our complete legal documentation:</p>
            <ul>
                <li><a href="#privacy-policy">Privacy Policy</a></li>
                <li><a href="#terms-conditions">Terms and Conditions</a></li>
                <li><a href="service-agreement.php">Full Service Agreement</a> - Comprehensive terms for all IT services</li>
            </ul>
        </div>

        <div class="document-section" id="privacy-policy">
            <h2>Privacy Policy</h2>

            <h3>1. Information We Collect</h3>
            <p>Mark's Tech Solution ("we," "our," or "us") collects information necessary to provide our computer repair and IT services:</p>

            <h4>Personal Information:</h4>
            <ul>
                <li>Contact information (name, address, email, phone number)</li>
                <li>Payment information (credit card details, billing address)</li>
                <li>Service preferences and history</li>
            </ul>
            <li>Diagnose and troubleshoot technical issues</li>
            <li>Install and configure software and hardware</li>
            <li>Setup and maintain wired/wireless networks</li>
            <li>Provide remote technical support</li>
            <li>Comply with legal obligations</li>
        </ul>

        <h3>3. Data Protection and Security</h3>
        <p>We implement appropriate technical and organizational security measures including:</p>
        <ul>
            <li>Encrypted data transmission during remote sessions</li>
            <li>Secure storage of customer data</li>
            <li>Regular system security updates</li>
            <li>Limited access to personal information</li>
            <li>Secure disposal of data when no longer needed</li>
        </ul>

        <h3>4. Data Retention</h3>
        <p>We retain personal information only as long as necessary for:</p>
        <ul>
            <li>Service warranty periods (typically 30-90 days)</li>
            <li>Legal and tax compliance requirements</li>
            <li>Ongoing service relationships</li>
        </ul>

        <h3>5. Your Rights</h3>
        <p>You have the right to:</p>
        <ul>
            <li>Access your personal information</li>
            <li>Correct inaccurate data</li>
            <li>Request deletion of your data</li>
            <li>Opt-out of marketing communications</li>
            <li>Request information about data processing</li>
        </ul>

        <h3>6. Third-Party Disclosure</h3>
        <p>We do not sell your personal information. We may share information with:</p>
        <ul>
            <li>Payment processors for transaction completion</li>
            <li>Software vendors for license validation</li>
            <li>Legal authorities when required by law</li>
        </ul>

        <div class="contact-info">
            <h3>Contact Information</h3>
            <p>For privacy-related questions or to exercise your rights, contact:</p>
            <p>Mark's Tech Solution<br>
            Email: m.geden01@markstechsolution.com<br>
            Phone: (617) 302-6011<br>
            Address: 16 Dale Rd, East Weymouth, MA 02189</p>
        </div>
    </div>

    <div id="terms-conditions" class="document-section">
        <h2>Terms and Conditions</h2>

        <h3>1. Services Provided</h3>
        <p>Mark's Tech Solution provides the following IT services:</p>
        <ul>
            <li>Computer hardware repair and maintenance (excluding screen repair)</li>
            <li>Software installation, configuration, and troubleshooting</li>
            <li>Virus and malware removal</li>
            <li>Data backup and recovery services</li>
            <li>Wired and wireless network setup and configuration</li>
            <li>Network administration and security</li>
            <li>Remote technical support</li>
            <li>On-site home and business visits</li>
            <li>Drop-off repair services</li>
            <li>IT consultations and tutorials</li>
        </ul>

        <h3>2. Service Limitations</h3>
        <p class="highlight">We cannot guarantee recovery of all data or resolution of all technical issues. Some problems may be beyond repair due to hardware failure, extensive damage, or other factors.</p>

        <h3>3. Payment Terms</h3>
        <ul>
            <li>Service fees are due upon completion of work unless otherwise arranged</li>
            <li>Diagnostic fees may apply for initial assessment</li>
            <li>Remote support: Minimum 1-hour charge, billed in 15-minute increments</li>
            <li>On-site visits: Minimum 2-hour charge, plus travel time if applicable</li>
            <li>Parts and software are additional to service fees</li>
            <li>Late payments may incur additional fees</li>
        </ul>

        <h3>4. Warranties</h3>
        <ul>
            <li><strong>Labor Warranty:</strong> 30 days on repairs performed</li>
            <li><strong>Parts Warranty:</strong> Manufacturer's warranty on replacement parts</li>
            <li><strong>No Warranty:</strong> Software installations and configurations are provided "as-is"</li>
            <li>Warranty void if device is tampered with by another service provider</li>
        </ul>

        <h3>5. Liability Limitations</h3>
        <p class="highlight">Our liability is limited to the cost of services provided. We are not liable for:</p>
        <ul>
            <li>Data loss - customers are responsible for data backup</li>
            <li>Consequential or incidental damages</li>
            <li>Loss of business or profits</li>
            <li>Issues arising after service completion due to customer actions</li>
        </ul>

        <h3>6. Customer Responsibilities</h3>
        <ul>
            <li>Back up all important data before service begins</li>
            <li>Disclose all known issues with the device</li>
            <li>Provide safe access for on-site visits</li>
            <li>Make payment as agreed</li>
            <li>Test services upon completion and report any issues within warranty period</li>
        </ul>

        <h3>7. Remote Access Authorization</h3>
        <p>By requesting remote support, you authorize us to:</p>
        <ul>
            <li>Access your computer system remotely</li>
            <li>Install necessary software for remote support</li>
            <li>Make configuration changes to resolve issues</li>
            <li>Monitor the remote session for quality assurance</li>
        </ul>

        <h3>8. Cancellation Policy</h3>
        <ul>
            <li>24-hour notice required for appointment cancellations</li>
            <li>Late cancellations may incur a fee</li>
            <li>No-shows will be charged the minimum service fee</li>
        </ul>

        <h3>9. Data Handling</h3>
        <ul>
            <li>We take reasonable care with your data but recommend you maintain backups</li>
            <li>Data recovery services are not guaranteed</li>
            <li>We securely delete any recovered data after service completion unless otherwise arranged</li>
        </ul>

        <h3>10. Network Services</h3>
        <ul>
            <li>Network setup includes basic configuration only</li>
            <li>Ongoing network security is the customer's responsibility</li>
            <li>We are not liable for security breaches after service completion</li>
            <li>Complex network configurations may require additional fees</li>
        </ul>

        <h3>11. Governing Law</h3>
        <p>These terms are governed by the laws of Massachusetts. Any disputes shall be resolved in the courts of [Your County], Massachusetts.</p>

        <h3>12. Changes to Terms</h3>
        <p>We reserve the right to modify these terms at any time. Continued use of our services constitutes acceptance of updated terms.</p>
    </div>
</main>

<script>
    document.getElementById('currentDate').textContent = new Date().toLocaleDateString('en-US', {
        year: 'numeric',
        month: 'long',
        day: 'numeric'
    });
</script>

<?php include __DIR__ . '/components/footer.php'; ?>