<?php
require_once 'csp_config.php';
require_once 'config_loader.php';
require_once 'CsrfProtection.php';

// Generate and send CSP header
send_security_headers();

// Start session for CSRF protection
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <script src="https://www.google.com/recaptcha/enterprise.js?onload=onloadCallback&render=explicit"
        async defer></script>
    <meta name="google-adsense-account" content="ca-pub-9807741295373154">
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-9807741295373154"
        crossorigin="anonymous"></script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Professional computer repair, network setup, and IT support services in East Weymouth, MA. On-site tech support, custom PC builds, and reliable tech solutions.">
    <meta name="keywords" content="computer repair, IT support, network setup, tech support, East Weymouth, MA, custom PC builds, wifi installation, computer services">
    <meta name="author" content="Mark's Tech Solution">
    <meta name="robots" content="index, follow">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://markstechsolution.com/">
    <meta property="og:title" content="Mark's Tech Solution - Professional IT Services in East Weymouth, MA">
    <meta property="og:description" content="Expert computer repair, network setup, and IT support services. Serving East Weymouth and surrounding areas with reliable tech solutions.">
    <meta property="og:image" content="https://markstechsolution.com/assets/og-image.jpg">
    <meta property="og:site_name" content="Mark's Tech Solution">
    <meta property="og:locale" content="en_US">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://markstechsolution.com/">
    <meta property="twitter:title" content="Mark's Tech Solution - Professional IT Services">
    <meta property="twitter:description" content="Expert computer repair, network setup, and IT support services in East Weymouth, MA.">
    <meta property="twitter:image" content="https://markstechsolution.com/assets/twitter-image.jpg">

    <!-- Additional SEO -->
    <link rel="canonical" href="https://markstechsolution.com/">
    <meta name="geo.region" content="US-MA">
    <meta name="geo.placename" content="East Weymouth">
    <meta name="geo.position" content="42.226008;-70.945108">
    <meta name="ICBM" content="42.226008, -70.945108">
    <title>Mark's Tech Solution - Your Local Tech Experts</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha512-9usAa10IRO0HhonpyAIVpjrylPvoDwiPUiKdWk5t3PyolY1cOd4DSE0Ga+ri4AuTroPR5aQvXU9xC6qOPnzFeg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <!-- Skip Navigation -->
    <a href="#main-content" class="skip-nav visually-hidden-focusable">Skip to main content</a>

    <?php include 'components/navbar.php'; ?>

    <!-- Hero Section -->
    <main id="main-content">
        <section id="home" class="hero" role="banner">
            <div class="container">
                <div class="row align-items-center min-vh-100">
                    <div class="col-lg-8 mx-auto text-center">
                        <img class="header_image" src="./assets/mts_logo.png" alt="Logo" height="500px"  width="500px">
                        <h1>Mark's Tech Solution</h1>
                        <p class="lead">Your Local Tech Experts in East Weymouth, MA</p>
                        <p>Professional on-site tech support, network setup, and computer repair services</p>
                        <a href="./contact.php#contact-form" class="btn btn-primary btn-lg mt-3">Get a Quote</a>
                    </div>
                </div>
            </div>
        </section>
        <!-- Services Section -->
        <section id="services" class="py-5">
            <div class="container">
                <h2 class="text-center mb-5">Our Services</h2>
                <div class="row g-4">
                    <div class="col-md-6 col-lg-4">
                        <a href="services/onsite-tech.php" class="text-decoration-none">
                            <div class="card h-100 service-card">
                                <div class="card-body text-center">
                                    <i class="fas fa-laptop-house fa-3x mb-3" aria-hidden="true"></i>
                                    <h5 class="card-title">On-Site Tech Services</h5>
                                    <p class="card-text">Professional tech support at your location.</p>
                                    <span class="text-primary">Learn more <i class="fas fa-arrow-right"></i></span>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <a href="services/wifi-network.php" class="text-decoration-none">
                            <div class="card h-100 service-card">
                                <div class="card-body text-center">
                                    <i class="fas fa-wifi fa-3x mb-3" aria-hidden="true"></i>
                                    <h5 class="card-title">Wi-Fi Network Installation</h5>
                                    <p class="card-text">Reliable wireless network setup for your home or office.</p>
                                    <span class="text-primary">Learn more <i class="fas fa-arrow-right"></i></span>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <a href="services/wired-network.php" class="text-decoration-none">
                            <div class="card h-100 service-card">
                                <div class="card-body text-center">
                                    <i class="fas fa-network-wired fa-3x mb-3" aria-hidden="true"></i>
                                    <h5 class="card-title">Wired Network Setup</h5>
                                    <p class="card-text">Professional installation of wired network infrastructure.</p>
                                    <span class="text-primary">Learn more <i class="fas fa-arrow-right"></i></span>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <a href="services/network-configuration.php" class="text-decoration-none">
                            <div class="card h-100 service-card">
                                <div class="card-body text-center">
                                    <i class="fas fa-cogs fa-3x mb-3" aria-hidden="true"></i>
                                    <h5 class="card-title">Router/Switch/Modem Setup</h5>
                                    <p class="card-text">Expert configuration of network equipment.</p>
                                    <span class="text-primary">Learn more <i class="fas fa-arrow-right"></i></span>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <a href="services/custom-computers.php" class="text-decoration-none">
                            <div class="card h-100 service-card">
                                <div class="card-body text-center">
                                    <i class="fas fa-desktop fa-3x mb-3" aria-hidden="true"></i>
                                    <h5 class="card-title">Custom Computer Builds</h5>
                                    <p class="card-text">Tailored computer systems to meet your specific needs.</p>
                                    <span class="text-primary">Learn more <i class="fas fa-arrow-right"></i></span>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <a href="services/computer-repair.php" class="text-decoration-none">
                            <div class="card h-100 service-card">
                                <div class="card-body text-center">
                                    <i class="fas fa-laptop-medical fa-3x mb-3" aria-hidden="true"></i>
                                    <h5 class="card-title">Computer Repair</h5>
                                    <p class="card-text">Professional drop-off & remote repair services for all Windows computers.</p>
                                    <span class="text-primary">Learn more <i class="fas fa-arrow-right"></i></span>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </section>

        <!-- Trust Badges Section -->
        <section id="trust-badges" class="py-5 bg-light">
            <div class="container">
                <h2 class="text-center mb-5">Why Choose Us?</h2>
                <div class="row text-center">
                    <div class="col-md-4">
                        <div class="card border-0">
                            <div class="card-body">
                                <i class="fas fa-shield-alt fa-3x mb-3 text-primary" aria-hidden="true"></i>
                                <h5 class="card-title">Certified Professionals</h5>
                                <p class="card-text">Our technicians are certified and experienced.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card border-0">
                            <div class="card-body">
                                <i class="fas fa-thumbs-up fa-3x mb-3 text-primary" aria-hidden="true"></i>
                                <h5 class="card-title">Satisfaction Guaranteed</h5>
                                <p class="card-text">We stand behind our work with a 100% satisfaction guarantee.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card border-0">
                            <div class="card-body">
                                <i class="fas fa-star fa-3x mb-3 text-primary" aria-hidden="true"></i>
                                <h5 class="card-title">5-Star Rated</h5>
                                <p class="card-text">We are proud to be a 5-star rated business on Google.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Testimonials Section -->
        <section id="testimonials" class="py-5" style="background-color: #ff6600;">
            <div class="container">
                <h2 class="text-center mb-5">What Our Clients Say</h2>
                <div class="row">
                    <div class="col-lg-6 mb-4">
                        <div class="card h-100">
                            <div class="card-body">
                                <p class="card-text">"Mark was a lifesaver! He fixed my Wi-Fi issues in no time. Highly recommend!"</p>
                                <footer class="blockquote-footer">Robin Cohen</footer>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 mb-4">
                        <div class="card h-100">
                            <div class="card-body">
                                <p class="card-text">"I visited Mark Tech Solution with a Laptop issue. It would not start. Mark devoted his energy & skills to help and revive my Laptop. His patience and serious commitment to the issue at hand seemed very impressive. His honesty in telling you what is needed was equally admirable. I think he's the right technician if you have any IT issues that you cannot solve."</p>
                                <footer class="blockquote-footer">Ignatius Njuguna</footer>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 mb-4">
                        <div class="card h-100">
                            <div class="card-body">
                                <p class="card-text">"Mark's Tech Solution has come to the rescue on many occasions and has saved the day. Hope Bible Church is a network of house churches that meets via zoom.. With out Marks technical expertise and patience we would never have made this work. He has been an unbelievable plus. Every one he has helped in the church has commented on how nice he is to work with and how patient he is. All of my interactions with Mark have been wonderful. I can not say enough about him and His Company"</p>
                                <footer class="blockquote-footer">Gary Morris</footer>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 mb-4">
                        <div class="card h-100">
                            <div class="card-body">
                                <p class="card-text">"My laptop keyboard had not been working for several months and Mark both diagnosed and solved my issue same day, and most importantly was able to avoid a costly parts replacement. Very grateful!"</p>
                                <footer class="blockquote-footer">Dan Yotive</footer>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </main>

    <?php include __DIR__ . '/components/footer.php'; ?>

</body>
</html>