<?php
/**
 * Generate and return CSRF token
 */

header('Content-Type: application/json');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Load CSRF protection
require_once 'CsrfProtection.php';

try {
    // Generate new token
    $token = CsrfProtection::generateToken();
    
    echo json_encode([
        'success' => true,
        'token' => $token
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Failed to generate CSRF token'
    ]);
}
?>
