<?php
/**
 * Configuration loader for environment variables
 */

// Load environment variables from .env file
if (file_exists(__DIR__ . '/.env')) {
    $lines = file(__DIR__ . '/.env', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos($line, '#') === 0) {
            continue; // Skip comments
        }
        
        if (strpos($line, '=') !== false) {
            list($key, $value) = explode('=', $line, 2);
            $key = trim($key);
            $value = trim($value);
            
            // Remove quotes if present
            $value = trim($value, '"\'');
            
            // Set environment variable
            putenv("$key=$value");
            $_ENV[$key] = $value;
        }
    }
}

/**
 * Get environment variable with fallback
 */
function env($key, $default = null) {
    $value = $_ENV[$key] ?? getenv($key);
    return $value !== false ? $value : $default;
}

/**
 * Get boolean environment variable
 */
function env_bool($key, $default = false) {
    $value = env($key, $default);
    return filter_var($value, FILTER_VALIDATE_BOOLEAN);
}

/**
 * Get integer environment variable
 */
function env_int($key, $default = 0) {
    $value = env($key, $default);
    return (int)$value;
}

/**
 * Get float environment variable
 */
function env_float($key, $default = 0.0) {
    $value = env($key, $default);
    return (float)$value;
}
