<?php
require_once dirname(__DIR__) . '/csp_config.php';
require_once dirname(__DIR__) . '/config_loader.php';
require_once dirname(__DIR__) . '/CsrfProtection.php';

$currentDir = trim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'] ?? '/')), '/');
$depth = ($currentDir === '') ? 0 : (substr_count($currentDir, '/') + 1);
$urlPrefix = ($depth === 0) ? '' : str_repeat('../', $depth);

// Generate and send CSP header
send_security_headers();

// Start session for CSRF protection
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <script src="https://www.google.com/recaptcha/enterprise.js?render=6LeUoSksAAAAAG7oSdSl4zKoBxmo7e1Pq5nih2iU"></script>
    <meta name="google-adsense-account" content="ca-pub-9807741295373154">
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-9807741295373154"
     crossorigin="anonymous"></script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Professional computer repair, network setup, and IT support services in East Weymouth, MA. On-site tech support, custom PC builds, and reliable tech solutions.">
    <meta name="keywords" content="computer repair, IT support, network setup, tech support, East Weymouth, MA, custom PC builds, wifi installation, computer services">
    <meta name="author" content="Mark's Tech Solution">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://markstechsolution.com/">
    <meta property="og:title" content="Mark's Tech Solution - Professional IT Services in East Weymouth, MA">
    <meta property="og:description" content="Expert computer repair, network setup, and IT support services. Serving East Weymouth and surrounding areas with reliable tech solutions.">
    <meta property="og:image" content="https://markstechsolution.com/images/og-image.jpg">
    <meta property="og:site_name" content="Mark's Tech Solution">
    <meta property="og:locale" content="en_US">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://markstechsolution.com/">
    <meta property="twitter:title" content="Mark's Tech Solution - Professional IT Services">
    <meta property="twitter:description" content="Expert computer repair, network setup, and IT support services in East Weymouth, MA.">
    <meta property="twitter:image" content="https://markstechsolution.com/images/twitter-image.jpg">
    
    <!-- Additional SEO -->
    <link rel="canonical" href="https://markstechsolution.com/">
    <meta name="geo.region" content="US-MA">
    <meta name="geo.placename" content="East Weymouth">
    <meta name="geo.position" content="42.226008;-70.945108">
    <meta name="ICBM" content="42.226008, -70.945108">
    <title><?php echo htmlspecialchars($pageTitle ?? "Mark's Tech Solution - Your Local Tech Experts", ENT_QUOTES, 'UTF-8'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha512-9usAa10IRO0HhonpyAIVpjrylPvoDwiPUiKdWk5t3PyolY1cOd4DSE0Ga+ri4AuTroPR5aQvXU9xC6qOPnzFeg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo $urlPrefix; ?>Main_Site/styles.css">

    <?php if (!empty($extraHead)) { echo $extraHead; } ?>
</head>
<body>
    <!-- Skip Navigation -->
    <a href="#main-content" class="skip-nav visually-hidden-focusable">Skip to main content</a>
    
    <?php include __DIR__ . '/navbar.php'; ?>
