<?php include '../components/header.php'; ?>

<style>
    .service-hero {
        background: linear-gradient(135deg, rgba(255, 102, 0, 0.1) 0%, rgba(204, 82, 0, 0.1) 100%);
        padding: 100px 0 60px;
        margin-top: 76px;
    }
    
    .service-icon {
        font-size: 4rem;
        color: var(--primary-color);
        margin-bottom: 1.5rem;
    }
    
    .service-features {
        background-color: #000000;
        border-radius: 10px;
        padding: 2rem;
        margin: 2rem 0;
        border: 2px solid var(--primary-color);
    }
    
    .feature-item {
        display: flex;
        align-items: flex-start;
        margin-bottom: 1rem;
    }
    
    .feature-item i {
        color: var(--primary-color);
        margin-right: 1rem;
        margin-top: 0.25rem;
    }
    
    .back-to-services {
        display: inline-flex;
        align-items: center;
        margin-bottom: 2rem;
        color: var(--primary-color);
        text-decoration: none;
    }
    
    .back-to-services:hover {
        text-decoration: underline;
    }
    
    .back-to-services i {
        transition: transform 0.3s ease;
        margin-right: 0.5rem;
    }
    
    .back-to-services:hover i {
        transform: translateX(-3px);
    }
</style>

<!-- Hero Section -->
<section class="service-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <a href="../index.php#services" class="back-to-services">
                    <i class="fas fa-arrow-left"></i> Back to All Services
                </a>
                <div class="service-icon">
                    <i class="fas fa-desktop"></i>
                </div>
                <h1>Custom Computer Builds</h1>
                <p class="lead">Tailor-made computer systems built specifically for your needs in East Weymouth and surrounding areas</p>
            </div>
        </div>
    </div>
</section>

<!-- Service Content -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="service-content">
                    <h2>About This Service</h2>
                    <p>Why settle for off-the-shelf computers that don't meet your exact needs? Our custom computer building service creates systems tailored specifically to your requirements, whether you're a gamer, content creator, business professional, or home user. We use high-quality components and expert assembly to deliver a computer that performs exactly as you need it to.</p>
                    
                    <div class="service-features">
                        <h3>Our Custom Build Services Include</h3>
                        <ul class="list-unstyled">
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Personalized Consultation</h5>
                                    <p class="mb-0 text-muted">We work with you to understand your needs and recommend the perfect components.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Professional Assembly</h5>
                                    <p class="mb-0 text-muted">Expert assembly with proper cable management and thermal optimization.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Software Installation</h5>
                                    <p class="mb-0 text-muted">Operating system setup and essential software installation.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <h5 class="mb-1">Performance Testing</h5>
                                    <p class="mb-0 text-muted">Comprehensive testing to ensure your system meets performance expectations.</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    
                    <h3>Why Choose a Custom Build?</h3>
                    <p>Custom computers offer superior performance, upgradeability, and value compared to pre-built systems. You get exactly what you need without paying for features you don't want, and the ability to upgrade individual components as technology advances.</p>
                    
                    <div class="mt-5 text-center">
                        <a href="../index.php#quote" class="btn btn-primary btn-lg">Start Your Custom Build</a>
                        <p class="mt-3 text-muted">Have questions? Call us at <a href="tel:6173026011">(617) 302-6011</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include '../components/footer.php'; ?>
