<?php
/**
 * Remove vendor directory (reCAPTCHA Enterprise not needed for v3)
 */

echo "=== Removing Vendor Directory ===\n\n";

$vendorDir = 'vendor/';

if (is_dir($vendorDir)) {
    echo "Found vendor directory (" . round(filesize($vendorDir) / 1024 / 1024, 2) . " MB)\n";
    
    // Check if it's safe to remove (only contains reCAPTCHA Enterprise)
    $recaptchaPath = $vendorDir . 'google/cloud-recaptcha-enterprise';
    if (is_dir($recaptchaPath)) {
        echo "✓ Contains reCAPTCHA Enterprise libraries\n";
        echo "⚠ This can be removed since you're using reCAPTCHA v3\n";
    } else {
        echo "⚠ Does not contain expected reCAPTCHA Enterprise libraries\n";
        echo "❌ Skipping removal for safety\n";
        exit(0);
    }
    
    // Remove vendor directory
    echo "Removing vendor directory...\n";
    
    function removeDirectory($dir) {
        if (!is_dir($dir)) {
            return;
        }
        
        $files = array_diff(scandir($dir), ['.', '..']);
        foreach ($files as $file) {
            $filePath = $dir . '/' . $file;
            if (is_dir($filePath)) {
                removeDirectory($filePath);
            } else {
                unlink($filePath);
            }
        }
        rmdir($dir);
    }
    
    removeDirectory($vendorDir);
    echo "✓ Vendor directory removed successfully\n";
    
} else {
    echo "Vendor directory not found\n";
}

echo "\n=== Removal Complete ===\n";
echo "The vendor directory has been removed.\n";
echo "Your application now uses reCAPTCHA v3 directly via Google CDN.\n";
echo "This reduces codebase size by ~50MB and eliminates maintenance overhead.\n";
?>
