<?php include '../components/header.php'; ?>

<style>
    .service-hero {
        background: linear-gradient(135deg, #ff6600 0%, #cc5200 100%);
        padding: 120px 0 80px;
        margin-top: 76px;
        position: relative;
        overflow: hidden;
    }
    
    .service-hero::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><text y="50" font-size="100" fill="rgba(255,255,255,0.05)">⚡</text></svg>');
        background-size: 100px 100px;
        animation: float 20s linear infinite;
    }
    
    @keyframes float {
        0% { transform: translateX(0) translateY(0); }
        100% { transform: translateX(-100px) translateY(-100px); }
    }
    
    .service-hero-content {
        position: relative;
        z-index: 2;
    }
    
    .service-icon {
        font-size: 5rem;
        color: #ffffff;
        margin-bottom: 2rem;
        text-shadow: 0 4px 15px rgba(0,0,0,0.3);
        animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.05); }
    }
    
    .service-hero h1 {
        color: #ffffff;
        font-size: 3.5rem;
        font-weight: 700;
        margin-bottom: 1.5rem;
        text-shadow: 0 4px 15px rgba(0,0,0,0.3);
    }
    
    .service-hero .lead {
        color: rgba(255,255,255,0.9);
        font-size: 1.4rem;
        font-weight: 300;
        margin-bottom: 2rem;
    }
    
    .service-badge {
        display: inline-block;
        background: rgba(255,255,255,0.2);
        color: #ffffff;
        padding: 0.5rem 1.5rem;
        border-radius: 50px;
        font-weight: 500;
        margin-bottom: 1rem;
        backdrop-filter: blur(10px);
    }
    
    .service-features {
        background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
        border-radius: 20px;
        padding: 3rem;
        margin: 3rem 0;
        border: 2px solid #ff6600;
        box-shadow: 0 20px 40px rgba(0,0,0,0.3);
        position: relative;
        overflow: hidden;
    }
    
    .service-features::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #ff6600, #ffaa00, #ff6600);
        animation: shimmer 3s linear infinite;
    }
    
    @keyframes shimmer {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(100%); }
    }
    
    .feature-item {
        display: flex;
        align-items: flex-start;
        margin-bottom: 2rem;
        padding: 1.5rem;
        background: rgba(255,255,255,0.05);
        border-radius: 15px;
        transition: all 0.3s ease;
        border: 1px solid rgba(255,102,0,0.3);
    }
    
    .feature-item:hover {
        transform: translateY(-5px);
        background: rgba(255,255,255,0.08);
        border-color: #ff6600;
        box-shadow: 0 10px 30px rgba(255,102,0,0.2);
    }
    
    .feature-item i {
        color: #ff6600;
        font-size: 1.5rem;
        margin-right: 1.5rem;
        margin-top: 0.25rem;
        flex-shrink: 0;
    }
    
    .feature-item h5 {
        color: #ffffff;
        font-weight: 600;
        margin-bottom: 0.5rem;
        font-size: 1.2rem;
    }
    
    .feature-item p {
        color: rgba(255,255,255,0.7);
        margin: 0;
        line-height: 1.6;
    }
    
    .service-details {
        background: #ffffff;
        border-radius: 20px;
        padding: 3rem;
        margin: 3rem 0;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        border-left: 5px solid #ff6600;
    }
    
    .service-details h3 {
        color: #ff6600;
        font-weight: 700;
        margin-bottom: 2rem;
        font-size: 2rem;
    }
    
    .service-details p {
        color: #333333;
        font-size: 1.1rem;
        line-height: 1.8;
        margin-bottom: 1.5rem;
    }
    
    .back-to-services {
        display: inline-flex;
        align-items: center;
        color: #ffffff;
        text-decoration: none;
        font-weight: 500;
        padding: 0.75rem 1.5rem;
        background: rgba(255,255,255,0.2);
        border-radius: 50px;
        backdrop-filter: blur(10px);
        transition: all 0.3s ease;
        margin-bottom: 2rem;
    }
    
    .back-to-services:hover {
        background: rgba(255,255,255,0.3);
        transform: translateY(-2px);
        color: #ffffff;
        text-decoration: none;
    }
    
    .back-to-services i {
        margin-right: 0.5rem;
        transition: transform 0.3s ease;
    }
    
    .back-to-services:hover i {
        transform: translateX(-3px);
    }
    
    .service-cta {
        background: linear-gradient(135deg, #ff6600 0%, #cc5200 100%);
        color: #ffffff;
        padding: 3rem;
        border-radius: 20px;
        text-align: center;
        margin: 3rem 0;
        box-shadow: 0 20px 40px rgba(255,102,0,0.3);
    }
    
    .service-cta h3 {
        font-size: 2rem;
        margin-bottom: 1.5rem;
        font-weight: 700;
    }
    
    .service-cta p {
        font-size: 1.2rem;
        margin-bottom: 2rem;
        opacity: 0.9;
    }
    
    .btn-service {
        background: #ffffff;
        color: #ff6600;
        padding: 1rem 2rem;
        border-radius: 50px;
        text-decoration: none;
        font-weight: 600;
        display: inline-block;
        transition: all 0.3s ease;
        border: none;
        font-size: 1.1rem;
    }
    
    .btn-service:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 30px rgba(255,255,255,0.3);
        color: #ff6600;
        text-decoration: none;
    }
    
    .service-highlight {
        background: linear-gradient(135deg, rgba(255,102,0,0.1) 0%, rgba(204,82,0,0.1) 100%);
        border-left: 4px solid #ff6600;
        padding: 1.5rem;
        border-radius: 10px;
        margin: 2rem 0;
    }
    
    .service-highlight p {
        color: #333333;
        font-weight: 500;
        margin: 0;
    }
    
    @media (max-width: 768px) {
        .service-hero h1 {
            font-size: 2.5rem;
        }
        
        .service-hero .lead {
            font-size: 1.2rem;
        }
        
        .service-features {
            padding: 2rem;
        }
        
        .feature-item {
            padding: 1rem;
        }
        
        .service-details {
            padding: 2rem;
        }
    }
</style>

<!-- Hero Section -->
<section class="service-hero">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto text-center">
                <div class="service-hero-content">
                    <a href="../index.php#services" class="back-to-services">
                        <i class="fas fa-arrow-left"></i> Back to All Services
                    </a>
                    <div class="service-badge">Wireless Network Solutions</div>
                    <div class="service-icon">
                        <i class="fas fa-wifi"></i>
                    </div>
                    <h1>WiFi Network Setup</h1>
                    <p class="lead">Professional wireless network engineering and optimization services for seamless connectivity throughout your home or business</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Service Content -->
<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="service-content">
                    <div class="service-details">
                        <h2>Advanced WiFi Network Engineering</h2>
                        <p>Mark's Tech Solution specializes in professional WiFi network design, installation, and optimization services. Our network engineers create robust, high-performance wireless networks that deliver reliable connectivity and optimal performance for all your devices.</p>
                        
                        <div class="service-highlight">
                            <p><strong>Service Model:</strong> Comprehensive WiFi network services including site surveys, access point placement optimization, configuration, and ongoing support. Both on-site and remote configuration available.</p>
                        </div>
                    </div>
                    
                    <div class="service-features">
                        <h3 style="color: #ffffff; font-size: 1.8rem; margin-bottom: 2rem;">Professional WiFi Capabilities</h3>
                        <ul class="list-unstyled">
                            <li class="feature-item">
                                <i class="fas fa-map-marked-alt"></i>
                                <div>
                                    <h5>Site Survey & Planning</h5>
                                    <p>Comprehensive wireless site analysis including signal strength mapping, interference detection, and optimal access point placement planning.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-broadcast-tower"></i>
                                <div>
                                    <h5>Access Point Installation</h5>
                                    <p>Professional mounting, configuration, and optimization of wireless access points for maximum coverage and performance.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-shield-alt"></i>
                                <div>
                                    <h5>Network Security Implementation</h5>
                                    <p>Advanced WiFi security including WPA3 encryption, guest network setup, firewall configuration, and intrusion prevention.</p>
                                </div>
                            </li>
                            <li class="feature-item">
                                <i class="fas fa-project-diagram"></i>
                                <div>
                                    <h5>Mesh Network Design</h5>
                                    <p>Seamless mesh network configuration for large homes and businesses requiring consistent WiFi coverage across multiple areas.</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    
                    <div class="service-details">
                        <h3>Enterprise-Grade WiFi Solutions</h3>
                        <p>We deliver sophisticated wireless networking solutions including multi-SSID configurations, load balancing, band steering, and advanced quality of service settings. Our expertise extends to both residential and commercial environments with complex connectivity requirements.</p>
                        
                        <p>Our WiFi services include comprehensive performance testing, channel optimization, and ongoing monitoring to ensure your wireless network maintains optimal performance and security standards.</p>
                    </div>
                    
                    <div class="service-cta">
                        <h3>Need Professional WiFi Setup?</h3>
                        <p>Contact us today to schedule a WiFi network consultation and get expert wireless networking solutions for your space.</p>
                        <a href="../contact_form_secure.php" class="btn-service">Schedule WiFi Consultation</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include '../components/services_footer.php'; ?>