<?php
/**
 * Content Security Policy Configuration
 */

// Define CSP header with proper directives
$csp_directives = [
    'script-src' => [
        "'self'",
        "'unsafe-inline'",
        "'unsafe-eval'",
        'https://www.google.com/recaptcha/',
        'https://www.gstatic.com/recaptcha/',
        'https://pagead2.googlesyndication.com',
        'https://cdn.jsdelivr.net',
        'https://www.google-analytics.com',
        'https://cdnjs.cloudflare.com',
        'https://googleads.g.doubleclick.net',
        'https://ep2.adtrafficquality.google',
        'https://tpc.googlesyndication.com',
        'https://googleads.g.doubleclick.net',
        'https://www.googletagmanager.com'
    ],
    'style-src' => [
        "'self'",
        "'unsafe-inline'",
        'https://fonts.googleapis.com',
        'https://cdn.jsdelivr.net',
        'https://cdnjs.cloudflare.com'
    ],
    'font-src' => [
        "'self'",
        'https://fonts.gstatic.com',
        'https://cdnjs.cloudflare.com'
    ],
    'img-src' => [
        "'self'",
        'data:',
        'https://www.google.com',
        'https://ssl.gstatic.com',
        'https://pagead2.googlesyndication.com',
        'https://ep1.adtrafficquality.google',
        'https://ep2.adtrafficquality.google'
    ],
    'connect-src' => [
        "'self'",
        'https://www.google.com',
        'https://www.gstatic.com',
        'https://pagead2.googlesyndication.com',
        'https://googleads.g.doubleclick.net',
        'https://cdn.jsdelivr.net',
        'https://cdnjs.cloudflare.com',
        'https://ep1.adtrafficquality.google',
        'https://ep2.adtrafficquality.google',
        'https://tpc.googlesyndication.com'
    ],
    'frame-src' => [
        "'self'",
        'https://www.google.com/recaptcha/',
        'https://www.google.com/',
        'https://googleads.g.doubleclick.net',
        'https://ep2.adtrafficquality.google',
        'https://tpc.googlesyndication.com'
    ],
    'object-src' => [
        "'none'"
    ],
    'base-uri' => [
        "'self'"
    ],
    'form-action' => [
        "'self'"
    ]
];

// Build CSP header string
$csp_header = '';
foreach ($csp_directives as $directive => $sources) {
    $csp_header .= $directive . ' ' . implode(' ', $sources) . '; ';
}

// Remove trailing space and semicolon
$csp_header = rtrim($csp_header, ' ;');

/**
 * Send CSP header
 */
function send_csp_header() {
    global $csp_header;
    header("Content-Security-Policy: $csp_header");
}

/**
 * Get CSP header as string
 */
function get_csp_header() {
    global $csp_header;
    return $csp_header;
}

/**
 * Send additional security headers
 */
function send_security_headers() {
    global $csp_header;
    
    // Add cache-busting timestamp
    $timestamp = time();
    header("Content-Security-Policy: $csp_header");
    header("Cache-Control: no-cache, no-store, must-revalidate");
    header("Pragma: no-cache");
    header("Expires: 0");
    
    // Additional security headers
    header('X-Content-Type-Options: nosniff');
    header('X-Frame-Options: DENY');
    header('X-XSS-Protection: 1; mode=block');
    header('Referrer-Policy: strict-origin-when-cross-origin');
    header('Permissions-Policy: geolocation=(), microphone=(), camera=(), payment=()');
}

// For development, you might want to use a more permissive CSP
function send_development_csp() {
    $dev_csp = "script-src 'self' 'unsafe-inline' 'unsafe-eval' https://www.google.com/recaptcha/ https://www.gstatic.com/recaptcha/ https://pagead2.googlesyndication.com https://cdn.jsdelivr.net; style-src 'self' 'unsafe-inline' https://fonts.googleapis.com https://cdn.jsdelivr.net; font-src 'self' https://fonts.gstatic.com; img-src 'self' data: https://www.google.com https://ssl.gstatic.com; connect-src 'self' https://www.google.com https://www.gstatic.com https://pagead2.googlesyndication.com; frame-src 'self' https://www.google.com/recaptcha/; object-src 'none';";
    header("Content-Security-Policy: $dev_csp");
}

?>
